/*
 * Decompiled with CFR 0.152.
 */
package model;

import data.Constants;
import data.Theme;
import model.Unit;
import org.lwjgl.opengl.GL11;
import view.StaticDrawer;

public class PlayerModel
extends Unit {
    private float originalRadius;
    private float currentRadius;
    private int band;
    private int originalband;
    private int reverseband;
    private int hunger;
    private float[] playerColor;
    public static float x = 0.0f;
    public static float y = 0.0f;

    public PlayerModel(float px, float py) {
        super(px, py);
        x = px;
        y = py;
        this.originalRadius = Constants.NORMAL_PLAYER_SIZE;
        this.currentRadius = Constants.NORMAL_PLAYER_SIZE;
        this.hunger = 0;
        this.originalband = this.band = 1;
        this.reverseband = 120 - this.band;
        this.setPlayerColor(StaticDrawer.getColorValues(this.band, 0.0f, true));
    }

    @Override
    public void draw(float k) {
        float[] fPlayerColors = StaticDrawer.getColorValues(this.band, k, true);
        this.playerColor = fPlayerColors;
        GL11.glEnable(3042);
        Theme.useThemeBlendingFunction();
        GL11.glColor4f(fPlayerColors[0], fPlayerColors[1], fPlayerColors[2], 1.0f);
        if (Theme.currentTheme == Theme.GLOW_THEME) {
            GL11.glEnable(3553);
            StaticDrawer.texture.bind();
            StaticDrawer.drawRadiance(this.currentRadius, this.band, x, y, fPlayerColors[0], fPlayerColors[1], fPlayerColors[2], 1.0f);
            GL11.glDisable(3553);
        } else if (Theme.currentTheme == Theme.SQUARE_THEME) {
            GL11.glRectf(x - this.currentRadius, y - this.currentRadius, x + this.currentRadius, y + this.currentRadius);
        }
        GL11.glDisable(3042);
    }

    public void resetRadius() {
        this.currentRadius = this.originalRadius;
    }

    public void setToMaxRadius() {
        this.currentRadius = Constants.MAX_PLAYER_SIZE;
    }

    public void changeSize(int change) {
        this.setCurrentRadius(this.originalRadius + (float)change);
    }

    public float getCurrentRadius() {
        return this.currentRadius;
    }

    public void setCurrentRadius(float currentRadius) {
        this.currentRadius = currentRadius;
    }

    public void updateBand(int band) {
        this.band = band;
        this.originalband = band;
        this.reverseband = 120 - band;
    }

    public int getBand() {
        return this.band;
    }

    public boolean isHungry() {
        return this.hunger == 0;
    }

    public void setHunger(float percent) {
        this.hunger = (int)((float)Constants.kirbyTime * percent);
    }

    public void digest() {
        if (this.hunger > 0) {
            --this.hunger;
        }
    }

    public void drawHungerMeter() {
        GL11.glColor3d(1.0, 1.0, 1.0);
        GL11.glBegin(7);
        GL11.glVertex2d(210.0, 40.0);
        GL11.glVertex2d(210 + this.hunger, 40.0);
        GL11.glVertex2d(210 + this.hunger, 50.0);
        GL11.glVertex2d(210.0, 50.0);
        GL11.glEnd();
        GL11.glBegin(2);
        GL11.glVertex2d(210.0, 40.0);
        GL11.glVertex2d(210 + Constants.kirbyTime, 40.0);
        GL11.glVertex2d(210 + Constants.kirbyTime, 50.0);
        GL11.glVertex2d(210.0, 50.0);
        GL11.glEnd();
    }

    public float[] getPlayerColor() {
        if (this.isHungry()) {
            return new float[]{1.0f, 1.0f, 1.0f};
        }
        return this.playerColor;
    }

    public void setPlayerColor(float[] playerColor) {
        this.playerColor = playerColor;
    }

    public float getPlayerX() {
        return x;
    }

    public float getPlayerY() {
        return y;
    }

    public void reversedBand() {
        this.band = this.reverseband;
    }

    public void originalBand() {
        this.band = this.originalband;
    }
}

